<?php
/**
 * Blog section
 *
 * This is the template for the content of latest_post section
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */
if ( ! function_exists( 'blogpost_add_weekly_top_section' ) ) :
    /**
    * Add latest_post section
    *
    *@since  Blogpost 1.0.0
    */
    function blogpost_add_weekly_top_section() {
        $options = blogpost_get_theme_options();
        // Check if latest_post is enabled on frontpage
        $weekly_top_enable = apply_filters( 'blogpost_section_status', true, 'weekly_top_section_enable' );

        if ( true !== $weekly_top_enable ) {
            return false;
        }
        // Get latest_post section details
        $section_details = array();
        $section_details = apply_filters( 'blogpost_filter_weekly_top_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }
        // Render latest_post section now.
        blogpost_render_weekly_top_section( $section_details );
    }
endif;

if ( ! function_exists( 'blogpost_get_weekly_top_section_details' ) ) :
    /**
    * latest_post section details.
    *
    * @since  Blogpost 1.0.0
    * @param array $input latest_post section details.
    */
    function blogpost_get_weekly_top_section_details( $input ) {
        $options = blogpost_get_theme_options();

        // Content type.
        $weekly_top_count = ! empty( $options['weekly_top_count'] ) ? $options['weekly_top_count'] : 3;
        
        $content = array();
        $cat_id = ! empty( $options['weekly_top_content_category'] ) ? $options['weekly_top_content_category'] : '';
        $args = array(
            'post_type'             => 'post',
            'posts_per_page'        => absint( $weekly_top_count ),
            'cat'                   => absint( $cat_id ),
            'ignore_sticky_posts'   => true,
        );                    

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = blogpost_trim_content( 30);
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-600x450.jpg';
                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// weekly_top section content details.
add_filter( 'blogpost_filter_weekly_top_section_details', 'blogpost_get_weekly_top_section_details' );


if ( ! function_exists( 'blogpost_render_weekly_top_section' ) ) :
  /**
   * Start latest_post section
   *
   * @return string latest_post content
   * @since  Blogpost 1.0.0
   *
   */
   function blogpost_render_weekly_top_section( $content_details = array() ) {
        $options                = blogpost_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>
    
            <div id="blogpost_weekly_top" class="page-section">
                <div class="wrapper">
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( $options['weekly_top_title'] ); ?></h2>
                        <p class="section-subtitle"><?php echo esc_html( $options['weekly_top_sub_title'] ); ?></p>
                    </div>

                    <div class="section-content <?php echo esc_attr( $options['weekly_top_column'] ); ?> clear">
                    <?php foreach($content_details as $content): ?>

                        <article class="has-post-thumbnail">
                            <div class="latest-post-wrapper">
                                <div class="featured-image" style="background-image: url('<?php echo esc_url($content['image']);?>');">
                                    <a href="<?php echo esc_url($content['url']);?>" class="post-thumbnail-link" title="<?php echo esc_attr($content['title']);?>"></a>
                                </div><!-- .featured-image -->

                                <div class="entry-container">
                                    <div class="entry-meta">
                                        <span class="cat-links">
                                            <?php the_category('', '', $content['id'])?>
                                        </span><!-- .cat-links -->
                                        <?php blogpost_posted_on($content['id']); ?>
                                    </div><!-- .entry-meta -->

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url($content['url']);?>"><?php echo esc_html($content['title']) ?></a></h2>
                                    </header>
                                </div><!-- .entry-container -->
                            </div>
                        </article>
                        <?php endforeach; ?>
   
                    </div><!-- .section-content -->
                </div>
            </div><!-- #weekly-top -->  

    <?php }
endif;  ?>
