<?php
/**
 * Banner section
 *
 * This is the template for the content of hero slider section
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */
if ( ! function_exists( 'blogpost_add_main_section' ) ) :
    /**
    * Add slider section
    *
    *@since  Blogpost 1.0.0
    */
    function blogpost_add_main_section() {
    	$options = blogpost_get_theme_options();
        // Check if slider is enabled on frontpage
        $main_enable = apply_filters( 'blogpost_section_status', true, 'main_section_enable' );

        if ( true !== $main_enable ) {
            return false;
        }
        // Get slider section details
        $section_details = array();
        $section_details = apply_filters( 'blogpost_filter_main_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render slider section now.
        blogpost_render_main_section( $section_details );
}

endif;

if ( ! function_exists( 'blogpost_get_main_section_details' ) ) :
    /**
    * slider section details.
    *
    * @since  Blogpost 1.0.0
    * @param array $input slider section details.
    */
    function blogpost_get_main_section_details( $input ) {
        $options = blogpost_get_theme_options();

        // Content type.
        $main_count           = ! empty( $options['main_count'] ) ? $options['main_count'] : 4;
        
        $content = array();
        $post_ids = array();
        for ( $i = 1; $i <= $main_count; $i++ ) {
            if ( ! empty( $options['main_content_post_' . $i] ) )
                $post_ids[] = $options['main_content_post_' . $i];
        }
        
        $args = array(
            'post_type'             => 'post',
            'post__in'              => ( array ) $post_ids,
            'posts_per_page'        => absint( $main_count ),
            'orderby'               => 'post__in',
            'ignore_sticky_posts'   => true,
        );                    

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri().'/assets/uploads/no-featured-image-600x450.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// slider section content details.
add_filter( 'blogpost_filter_main_section_details', 'blogpost_get_main_section_details' );


if ( ! function_exists( 'blogpost_render_main_section' ) ) :
  /**
   * Start slider section
   *
   * @return string slider content
   * @since  Blogpost 1.0.0
   *
   */
   function blogpost_render_main_section( $content_details = array() ) {
        $options = blogpost_get_theme_options();
        $main_autoplay_enable = ($options['main_autoplay_enable']) ? 'true' : 'false';

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="blogpost_main" class="relative page-section">
            <div class="wrapper">
                <div class="section-header">
                    <h2 class="section-title"><?php echo esc_html( $options['main_title'] ); ?> <span><?php echo esc_html( $options['main_sub_title'] ); ?></span></h2>
                </div>

                <div class="main-section-slider" data-slick='{"slidesToShow": 3, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": false, "arrows":true, "autoplay": <?php echo esc_attr( $main_autoplay_enable ); ?>, "draggable": true, "fade": false }'>
                    <?php foreach ( $content_details as $content ) : ?>
                    <article>
                        <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                            <div class="entry-container">
                                <div class="entry-meta">
                                    <span class="cat-links">
                                        <?php the_category('', '', $content['id'])?>
                                    </span><!-- .cat-links -->                            
                                </div><!-- .entry-meta -->

                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                </header>
                            </div><!-- .entry-container -->
                        </div><!-- .featured-image -->
                    </article>

                    <?php endforeach; ?>
                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- #main-section -->

<?php
    }    
endif;