<?php
/**
 * Blog section
 *
 * This is the template for the content of latest_posts section
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */
if ( ! function_exists( 'blogpost_add_latest_posts_section' ) ) :
    /**
    * Add latest_posts section
    *
    *@since  Blogpost 1.0.0
    */
    function blogpost_add_latest_posts_section() {
        $options = blogpost_get_theme_options();
        // Check if latest_posts is enabled on frontpage
        $latest_posts_enable = apply_filters( 'blogpost_section_status', true, 'latest_posts_section_enable' );

        if ( true !== $latest_posts_enable ) {
            return false;
        }
        // Get latest_posts section details
        $section_details = array();
        $section_details = apply_filters( 'blogpost_filter_latest_posts_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }
        // Render latest_posts section now.
        blogpost_render_latest_posts_section( $section_details );
    }
endif;

if ( ! function_exists( 'blogpost_get_latest_posts_section_details' ) ) :
    /**
    * latest_posts section details.
    *
    * @since  Blogpost 1.0.0
    * @param array $input latest_posts section details.
    */
    function blogpost_get_latest_posts_section_details( $input ) {
        $options = blogpost_get_theme_options();

        // Content type.
        $latest_posts_count = ! empty( $options['latest_posts_count'] ) ? $options['latest_posts_count'] : 4;

        $content = array();
        $cat_ids = ! empty( $options['latest_posts_category_exclude'] ) ? $options['latest_posts_category_exclude'] : array();
        $args = array(
            'post_type'             => 'post',
            'posts_per_page'        => absint( $latest_posts_count ),
            'category__not_in'      => ( array ) $cat_ids,
            'paged'    				=> 1,
            'ignore_sticky_posts'   => true,
        );                    

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = blogpost_trim_content( $options['latest_posts_excerpt_length']);
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-600x450.jpg';
                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// latest_posts section content details.
add_filter( 'blogpost_filter_latest_posts_section_details', 'blogpost_get_latest_posts_section_details' );


if ( ! function_exists( 'blogpost_render_latest_posts_section' ) ) :
  /**
   * Start latest_posts section
   *
   * @return string latest_posts content
   * @since  Blogpost 1.0.0
   *
   */
   function blogpost_render_latest_posts_section( $content_details = array() ) {
        $options                = blogpost_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

            <div id="content-wrapper" class="same-background">
                <div class="wrapper">
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html($options['latest_posts_title']); ?></h2>
                    </div>
                    <div id="primary" class="content-area clear">
                        <div id="blogpost_latest_posts" class="grid-layout">
                            <?php foreach($content_details as $content) : ?>

                            <article class="has-post-thumbnail">
                                <div class="latest-post-wrapper">
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url($content['image']);?>');">
                                        <a href="<?php echo esc_url($content['url']);?>" class="post-thumbnail-link" title="<?php echo esc_attr($content['title']);?>"></a>
                                    </div><!-- .featured-image -->

                                    <div class="entry-container">
                                        <div class="entry-meta">
                                            <span class="cat-links">
                                                <?php the_category('', '', $content['id'])?>

                                            </span><!-- .cat-links -->

                                            <?php blogpost_posted_on($content['id']); ?>
                                            <span class="min-read"><?php echo blogpost_reading_time($content['id']); ?></span>

                                        </div><!-- .entry-meta -->

                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url($content['url']);?>" tabindex="0"><?php echo esc_html($content['title']) ?></a></h2>
                                        </header>

                                        <div class="entry-content">
                                            <p><?php echo wp_kses_post($content['excerpt']);?></p>
                                        </div><!-- .entry-content -->

                                        <div class="read-more">
                                            <a href="<?php echo esc_url($content['url']);?>"><?php echo esc_html__( 'Read More', 'blogpost' ); ?></a>
                                        </div>
                                    </div><!-- .entry-container -->
                                </div>
                            </article>
                            <?php endforeach; ?>

                        </div><!-- #popular-posts -->
                    </div>

                    <?php if(is_active_sidebar( 'popular-post-section-sidebar' )) : ?>
                        <div id="secondary" class="widget-area">
                            <?php dynamic_sidebar( 'popular-post-section-sidebar' ); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

    <?php }
endif;  ?>
