<?php
/**
 * Call To Action section
 *
 * This is the template for the content of Call To Action section
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */
if ( ! function_exists( 'blogpost_add_call_to_action_section' ) ) :
    /**
    * Add Call To Action section
    *
    *@since  Blogpost 1.0.0
    */
    function blogpost_add_call_to_action_section() {
        $options = blogpost_get_theme_options();
        
        // Check if Call To Action is enabled on frontpage
        $call_to_action_enable = apply_filters( 'blogpost_section_status', true, 'call_to_action_section_enable' );

        if ( true !== $call_to_action_enable ) {
            return false;
        }

        // Get Call To Action section details
        $section_details = array();
        $section_details = apply_filters( 'blogpost_filter_call_to_action_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }

        // Render Call To Action section now.
        blogpost_render_call_to_action_section( $section_details[0] );
    }
endif;

if ( ! function_exists( 'blogpost_get_call_to_action_section_details' ) ) :
    /**
    * Call To Action section details.
    *
    * @since  Blogpost 1.0.0
    * @param array $input Call To Action section details.
    */
    function blogpost_get_call_to_action_section_details( $input ) {
        $options = blogpost_get_theme_options();

        $content = array();
        $page_id = ! empty( $options['call_to_action_content_page'] ) ? $options['call_to_action_content_page'] : '';
        $args = array(
                'post_type'             => 'page',
                'posts_per_page'        => 1,
                'p'                     => $page_id,
                'ignore_sticky_posts'   => true,
            );                    
    
        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = blogpost_trim_content( absint($options['call_to_action_excerpt_length']) );
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri().'/assets/uploads/no-featured-image-600x450.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;

// Call To Action section content details.
add_filter( 'blogpost_filter_call_to_action_section_details', 'blogpost_get_call_to_action_section_details' );


if ( ! function_exists( 'blogpost_render_call_to_action_section' ) ) :
  /**
   * Start Call To Action section
   *
   * @return string Call To Action content
   * @since  Blogpost 1.0.0
   *
   */
   function blogpost_render_call_to_action_section( $content_details = array() ) {
        $options    = blogpost_get_theme_options();
        $btn_label  = $options['call_to_action_read_more'];

        if ( empty( $content_details ) ) {
            return;
        } ?>
        <div id="blogpost_call_to_action" class="relative page-section">
            <div class="wrapper">
                <div class="section-header">
                    <h2 class="section-title"><?php echo esc_html($options['call_to_action_section_title']); ?></h2>
                </div>
                <div class="about-content">
                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content_details['image'] ); ?>');"></div>

                    <div class="about-content-wrapper">
                        <div class="entry-container">
                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php echo esc_url( $content_details['url'] ); ?>"><?php echo esc_html($content_details['title']); ?></a></h2>
                            </header>

                            <div class="entry-content">
                                <p><?php echo wp_kses_post($content_details['excerpt']); ?></p>
                            </div>

                            <?php if( !empty($btn_label) && !empty( $content_details['url'] )) : ?>
                                <div class="view-more">
                                    <a href="<?php echo esc_url( $content_details['url'] ); ?>"><?php echo esc_html($btn_label); ?></a>
                                </div>
                            <?php endif; ?>

                        </div><!-- .entry-container -->
                    </div>
                </div>
            </div><!-- .wrapper -->
        </div><!-- #call to action -->

    <?php }
endif;