<?php
/**
 * Theme Palace options
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */

/**
 * List of pages for page choices.
 * @return Array Array of page ids and name.
 */
function blogpost_page_choices() {
    $pages = get_pages();
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'blogpost' );
    foreach ( $pages as $page ) {
        $choices[ $page->ID ] = $page->post_title;
    }
    return  $choices;
}

/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function blogpost_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'blogpost' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    wp_reset_postdata();
    return  $choices;
}

/**
 * List of category for category choices.
 * @return Array Array of post ids and name.
 */
function blogpost_category_choices() {
    $tax_args = array(
        'hierarchical' => 0,
        'taxonomy'     => 'category',
    );
    $taxonomies = get_categories( $tax_args );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'blogpost' );
    foreach ( $taxonomies as $tax ) {
        $choices[ $tax->term_id ] = $tax->name;
    }
    return  $choices;
}

if ( ! function_exists( 'blogpost_site_layout' ) ) :
    /**
     * Site Layout
     * @return array site layout options
     */
    function blogpost_site_layout() {
        $blogpost_site_layout = array(
            'wide'          => esc_url( get_template_directory_uri() . '/assets/images/full.png' ),
            'boxed-layout'  => esc_url( get_template_directory_uri() . '/assets/images/boxed.png' ),
        );

        $output = apply_filters( 'blogpost_site_layout', $blogpost_site_layout );
        return $output;
    }
endif;

if ( ! function_exists( 'blogpost_selected_sidebar' ) ) :
    /**
     * Sidebars options
     * @return array Sidbar positions
     */
    function blogpost_selected_sidebar() {
        $blogpost_selected_sidebar = array(
            'sidebar-1'             => esc_html__( 'Default Sidebar', 'blogpost' ),
            'optional-sidebar'      => esc_html__( 'Optional Sidebar 1', 'blogpost' ),
        );

        $output = apply_filters( 'blogpost_selected_sidebar', $blogpost_selected_sidebar );

        return $output;
    }
endif;


if ( ! function_exists( 'blogpost_global_sidebar_position' ) ) :
    /**
     * Global Sidebar position
     * @return array Global Sidebar positions
     */
    function blogpost_global_sidebar_position() {
        $blogpost_global_sidebar_position = array(
            'right-sidebar' => esc_url( get_template_directory_uri() . '/assets/images/right.png' ),
            'no-sidebar'    => esc_url( get_template_directory_uri() . '/assets/images/full.png' ),
        );

        $output = apply_filters( 'blogpost_global_sidebar_position', $blogpost_global_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'blogpost_sidebar_position' ) ) :
    /**
     * Sidebar position
     * @return array Sidbar positions
     */
    function blogpost_sidebar_position() {
        $blogpost_sidebar_position = array(
            'right-sidebar'         => esc_url( get_template_directory_uri() . '/assets/images/right.png' ),
            'no-sidebar'            => esc_url( get_template_directory_uri() . '/assets/images/full.png' ),
        );

        $output = apply_filters( 'blogpost_sidebar_position', $blogpost_sidebar_position );

        return $output;
    }
endif;

if ( ! function_exists( 'blogpost_pagination_options' ) ) :
    /**
     * Pagination
     * @return array site pagination options
     */
    function blogpost_pagination_options() {
        $blogpost_pagination_options = array(
            'numeric'   => esc_html__( 'Numeric', 'blogpost' ),
            'default'   => esc_html__( 'Default(Older/Newer)', 'blogpost' ),
        );

        $output = apply_filters( 'blogpost_pagination_options', $blogpost_pagination_options );

        return $output;
    }
endif;

if ( ! function_exists( 'blogpost_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function blogpost_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'blogpost' ),
            'off'       => esc_html__( 'Disable', 'blogpost' )
        );
        return apply_filters( 'blogpost_switch_options', $arr );
    }
endif;

if ( ! function_exists( 'blogpost_hide_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function blogpost_hide_options() {
        $arr = array(
            'on'        => esc_html__( 'Yes', 'blogpost' ),
            'off'       => esc_html__( 'No', 'blogpost' )
        );
        return apply_filters( 'blogpost_hide_options', $arr );
    }
endif;

if ( ! function_exists( 'blogpost_sortable_sections' ) ) :
    /**
     * List of sections Control options
     * @return array List of Sections control options.
     */
    function blogpost_sortable_sections() {
        $options = blogpost_get_theme_options();
  
        $sections = array(

            'main'                   => esc_html__( 'Main Section', 'blogpost' ),
            'call_to_action'         => esc_html__( 'Call To Action', 'blogpost' ),
            'latest_posts'           => esc_html__( 'Latest Posts', 'blogpost' ),
            'weekly_top'             => esc_html__( 'Weekly Top', 'blogpost' ),
        );
         
        return apply_filters( 'blogpost_sortable_sections', $sections );
    }
endif;