<?php
/**
* Customizer validation functions
*
* @package Theme Palace
* @subpackage  Blogpost
* @since  Blogpost 1.0.0
*/

if ( ! function_exists( 'blogpost_validate_long_excerpt' ) ) :
    function blogpost_validate_long_excerpt( $validity, $value ){
        $value = intval( $value );
        if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'blogpost' ) );
        } elseif ( $value < 5 ) {
            $validity->add( 'min_no_of_words', esc_html__( 'Minimum no of words is 5', 'blogpost' ) );
        } elseif ( $value > 100 ) {
            $validity->add( 'max_no_of_words', esc_html__( 'Maximum no of words is 100', 'blogpost' ) );
        }
        return $validity;
    }
endif;

if ( ! function_exists( 'blogpost_validate_latest_posts_count' ) ) :
    function blogpost_validate_latest_posts_count( $validity, $value ){
           $value = intval( $value );
       if ( empty( $value ) || ! is_numeric( $value ) ) {
           $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'blogpost' ) );
       } elseif ( $value < 3 ) {
           $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 3', 'blogpost' ) );
       } elseif ( $value > 9 ) {
           $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 9', 'blogpost' ) );
       }
       return $validity;
    }
endif;

if ( ! function_exists( 'blogpost_validate_main_count' ) ) :
    function blogpost_validate_main_count( $validity, $value ){
           $value = intval( $value );
       if ( empty( $value ) || ! is_numeric( $value ) ) {
           $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'blogpost' ) );
       } elseif ( $value < 1 ) {
           $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'blogpost' ) );
       } elseif ( $value > 10 ) {
           $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 10', 'blogpost' ) );
       }
       return $validity;
    }
endif;

if ( ! function_exists( 'blogpost_validate_weekly_top_count' ) ) :
    function blogpost_validate_weekly_top_count( $validity, $value ){
           $value = intval( $value );
       if ( empty( $value ) || ! is_numeric( $value ) ) {
           $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'blogpost' ) );
       } elseif ( $value < 2) {
           $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 2', 'blogpost' ) );
       } elseif ( $value > 12 ) {
           $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'blogpost' ) );
       }
       return $validity;
    }
endif;
