<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */

// Add excerpt section
$wp_customize->add_section( 'blogpost_single_post_section',
	array(
		'title'             => esc_html__( 'Single Post','blogpost' ),
		'description'       => esc_html__( 'Options to change the single posts globally.', 'blogpost' ),
		'panel'             => 'blogpost_theme_options_panel',
	)
);

// Archive date meta setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[single_post_hide_date]',
	array(
		'default'           => $options['single_post_hide_date'],
		'sanitize_callback' => 'blogpost_sanitize_switch_control',
	)
);

$wp_customize->add_control( new  Blogpost_Switch_Control( $wp_customize,
	'blogpost_theme_options[single_post_hide_date]',
		array(
			'label'             => esc_html__( 'Hide Date', 'blogpost' ),
			'section'           => 'blogpost_single_post_section',
			'on_off_label' 		=> blogpost_hide_options(),
		)
	)
);

// Archive author meta setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[single_post_hide_author]',
	array(
		'default'           => $options['single_post_hide_author'],
		'sanitize_callback' => 'blogpost_sanitize_switch_control',
	)
);

$wp_customize->add_control( new  Blogpost_Switch_Control( $wp_customize,
	'blogpost_theme_options[single_post_hide_author]',
		array(
			'label'             => esc_html__( 'Hide Author', 'blogpost' ),
			'section'           => 'blogpost_single_post_section',
			'on_off_label' 		=> blogpost_hide_options(),
		)
	)
);
