<?php
/**
 * Reset options
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */

/**
* Reset section
*/
// Add reset enable section
$wp_customize->add_section( 'blogpost_reset_section',
	array(
		'title'             => esc_html__('Reset all settings','blogpost'),
		'description'       => esc_html__( 'Caution: All settings will be reset to default. Refresh the page after clicking Save & Publish.', 'blogpost' ),
	)
);

// Add reset enable setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[reset_options]',
	array(
		'default'           => $options['reset_options'],
		'sanitize_callback' => 'blogpost_sanitize_checkbox',
		'transport'			=> 'postMessage',
	)
);

$wp_customize->add_control( 'blogpost_theme_options[reset_options]',
	array(
		'label'             => esc_html__( 'Check to reset all settings', 'blogpost' ),
		'section'           => 'blogpost_reset_section',
		'type'              => 'checkbox',
	)
);
