<?php
/**
 * pagination options
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'blogpost_pagination',
	array(
		'title'               	=> esc_html__('Pagination','blogpost'),
		'description'         	=> esc_html__( 'Pagination section options.', 'blogpost' ),
		'panel'               	=> 'blogpost_theme_options_panel',
	)
);

// Sidebar position setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[pagination_enable]',
	array(
		'sanitize_callback' 	=> 'blogpost_sanitize_switch_control',
		'default'             	=> $options['pagination_enable'],
	)
);

$wp_customize->add_control( new  Blogpost_Switch_Control( $wp_customize,
	'blogpost_theme_options[pagination_enable]',
		array(
			'label'               	=> esc_html__( 'Pagination Enable', 'blogpost' ),
			'section'             	=> 'blogpost_pagination',
			'on_off_label' 			=> blogpost_switch_options(),
		)
	)
);

// Site layout setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[pagination_type]',
	array(
		'sanitize_callback'   	=> 'blogpost_sanitize_select',
		'default'             	=> $options['pagination_type'],
	)
);

$wp_customize->add_control( 'blogpost_theme_options[pagination_type]',
	array(
		'label'               	=> esc_html__( 'Pagination Type', 'blogpost' ),
		'section'             	=> 'blogpost_pagination',
		'type'                	=> 'select',
		'choices'			  	=> blogpost_pagination_options(),
		'active_callback'	  	=> 'blogpost_is_pagination_enable',
	)
);
