<?php
/**
 * Menu options
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'blogpost_menu',
	array(
		'title'             => esc_html__('Header Menu','blogpost'),
		'description'       => esc_html__( 'Header Menu options.', 'blogpost' ),
		'panel'             => 'nav_menus',
	)
);


$wp_customize->add_setting( 'blogpost_theme_options[search_icon_in_primary_menu_enable]',
	array(
		'sanitize_callback' => 'blogpost_sanitize_switch_control',
		'default'           => $options['search_icon_in_primary_menu_enable'],
	)
);

$wp_customize->add_control( new  Blogpost_Switch_Control( $wp_customize,
	'blogpost_theme_options[search_icon_in_primary_menu_enable]',
		array(
			'label'             => esc_html__( 'Show Search Icon', 'blogpost' ),
			'description'       => esc_html__( 'Show Search Icon in Primary menu', 'blogpost' ),
			'section'           => 'blogpost_menu',
			'on_off_label' 		=> blogpost_switch_options(),
		)
	)
);
