<?php
/**
 * Layout options
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'blogpost_layout',
	array(
		'title'               => esc_html__('Layout','blogpost'),
		'description'         => esc_html__( 'Layout section options.', 'blogpost' ),
		'panel'               => 'blogpost_theme_options_panel',
	)
);

// Site layout setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[site_layout]',
	array(
		'sanitize_callback'   => 'blogpost_sanitize_select',
		'default'             => $options['site_layout'],
	)
);

$wp_customize->add_control(  new  Blogpost_Custom_Radio_Image_Control ( $wp_customize,
	'blogpost_theme_options[site_layout]',
		array(
			'label'               => esc_html__( 'Site Layout', 'blogpost' ),
			'section'             => 'blogpost_layout',
			'choices'			  => blogpost_site_layout(),
		)
	)
);

// Sidebar position setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[sidebar_position]',
	array(
		'sanitize_callback'   => 'blogpost_sanitize_select',
		'default'             => $options['sidebar_position'],
	)
);

$wp_customize->add_control(  new  Blogpost_Custom_Radio_Image_Control ( $wp_customize,
	'blogpost_theme_options[sidebar_position]',
		array(
			'label'               => esc_html__( 'Global Sidebar Position', 'blogpost' ),
			'section'             => 'blogpost_layout',
			'choices'			  => blogpost_global_sidebar_position(),
		)
	)
);

// Post sidebar position setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[post_sidebar_position]',
	array(
		'sanitize_callback'   => 'blogpost_sanitize_select',
		'default'             => $options['post_sidebar_position'],
	)
);

$wp_customize->add_control(  new  Blogpost_Custom_Radio_Image_Control ( $wp_customize,
	'blogpost_theme_options[post_sidebar_position]',
		array(
			'label'               => esc_html__( 'Posts Sidebar Position', 'blogpost' ),
			'section'             => 'blogpost_layout',
			'choices'			  => blogpost_sidebar_position(),
		)
	)
);

// Post sidebar position setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[page_sidebar_position]',
	array(
		'sanitize_callback'   => 'blogpost_sanitize_select',
		'default'             => $options['page_sidebar_position'],
	)
);

$wp_customize->add_control( new  Blogpost_Custom_Radio_Image_Control( $wp_customize,
	'blogpost_theme_options[page_sidebar_position]',
		array(
			'label'               => esc_html__( 'Pages Sidebar Position', 'blogpost' ),
			'section'             => 'blogpost_layout',
			'choices'			  => blogpost_sidebar_position(),
		)
	)
);