<?php
/**
* Homepage (Static ) options
*
* @package Theme Palace
* @subpackage Blogpost
* @since Blogpost 1.0.0
*/

// Homepage (Static ) setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[enable_frontpage_content]',
	array(
		'sanitize_callback'   => 'blogpost_sanitize_checkbox',
		'default'             => $options['enable_frontpage_content'],
	)
);

$wp_customize->add_control( 'blogpost_theme_options[enable_frontpage_content]',
	array(
		'label'       	=> esc_html__( 'Enable Content', 'blogpost' ),
		'description' 	=> esc_html__( 'Check to enable content on static front page only.', 'blogpost' ),
		'section'     	=> 'static_front_page',
		'type'        	=> 'checkbox',
		'active_callback' => 'blogpost_is_static_homepage_enable',
	)
);