<?php
/**
 * Footer options
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */

// Footer Section
$wp_customize->add_section( 'blogpost_section_footer',
	array(
		'title'      			=> esc_html__( 'Footer Options', 'blogpost' ),
		'priority'   			=> 900,
		'panel'      			=> 'blogpost_theme_options_panel',
	)
);

// footer text
$wp_customize->add_setting( 'blogpost_theme_options[copyright_text]',
	array(
		'default'       		=> $options['copyright_text'],
		'sanitize_callback'		=> 'blogpost_santize_allow_tag',
		'transport'				=> 'postMessage',
	)
);

$wp_customize->add_control( 'blogpost_theme_options[copyright_text]',
    array(
		'label'      			=> esc_html__( 'Copyright Text', 'blogpost' ),
		'section'    			=> 'blogpost_section_footer',
		'type'		 			=> 'textarea',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'blogpost_theme_options[copyright_text]',
		array(
			'selector'            => '.site-info .wrapper',
			'settings'            => 'blogpost_theme_options[copyright_text]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'blogpost_copyright_text_partial',
		)
	);
}

// scroll top visible
$wp_customize->add_setting( 'blogpost_theme_options[scroll_top_visible]',
	array(
		'default'       	=> $options['scroll_top_visible'],
		'sanitize_callback' => 'blogpost_sanitize_switch_control',
	)
);

$wp_customize->add_control( new  Blogpost_Switch_Control( $wp_customize,
	'blogpost_theme_options[scroll_top_visible]',
		array(
			'label'      		=> esc_html__( 'Display Scroll Top Button', 'blogpost' ),
			'section'    		=> 'blogpost_section_footer',
			'on_off_label' 		=> blogpost_switch_options(),
		)
	)
);
