<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */

// Add excerpt section
$wp_customize->add_section( 'blogpost_excerpt_section',
	array(
		'title'             => esc_html__( 'Excerpt','blogpost' ),
		'description'       => esc_html__( 'Excerpt section options.', 'blogpost' ),
		'panel'             => 'blogpost_theme_options_panel',
	)
);


// long Excerpt length setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[long_excerpt_length]',
	array(
		'sanitize_callback' => 'blogpost_sanitize_number_range',
		'validate_callback' => 'blogpost_validate_long_excerpt',
		'default'			=> $options['long_excerpt_length'],
	)
);

$wp_customize->add_control( 'blogpost_theme_options[long_excerpt_length]',
	array(
		'label'       		=> esc_html__( 'Blog Page Excerpt Length', 'blogpost' ),
		'description' 		=> esc_html__( 'Total words to be displayed in archive page/search page.', 'blogpost' ),
		'section'     		=> 'blogpost_excerpt_section',
		'type'        		=> 'number',
		'input_attrs' 		=> array(
			'style'       => 'width: 80px;',
			'max'         => 100,
			'min'         => 5,
		),
	)
);
