<?php
/**
 * Breadcrumb options
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */

$wp_customize->add_section( 'blogpost_breadcrumb',
	array(
		'title'             => esc_html__( 'Breadcrumb','blogpost' ),
		'description'       => esc_html__( 'Breadcrumb section options.', 'blogpost' ),
		'panel'             => 'blogpost_theme_options_panel',
	)
);

// Breadcrumb enable setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[breadcrumb_enable]',
	array(
		'sanitize_callback' => 'blogpost_sanitize_switch_control',
		'default'          	=> $options['breadcrumb_enable'],
	)
);

$wp_customize->add_control( new  Blogpost_Switch_Control( $wp_customize,
	'blogpost_theme_options[breadcrumb_enable]',
		array(
			'label'            	=> esc_html__( 'Enable Breadcrumb', 'blogpost' ),
			'section'          	=> 'blogpost_breadcrumb',
			'on_off_label' 		=> blogpost_switch_options(),
		)
	)
);

// Breadcrumb separator setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[breadcrumb_separator]',
	array(
		'sanitize_callback'	=> 'sanitize_text_field',
		'default'          	=> $options['breadcrumb_separator'],
	)
);

$wp_customize->add_control( 'blogpost_theme_options[breadcrumb_separator]',
	array(
		'label'            	=> esc_html__( 'Separator', 'blogpost' ),
		'active_callback' 	=> 'blogpost_is_breadcrumb_enable',
		'section'          	=> 'blogpost_breadcrumb',
	)
);
