<?php
/**
 * Archive options
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */

// Add archive section
$wp_customize->add_section( 'blogpost_archive_section',
	array(
		'title'             => esc_html__( 'Blog/Archive','blogpost' ),
		'description'       => esc_html__( 'Archive section options.', 'blogpost' ),
		'panel'             => 'blogpost_theme_options_panel',
	)
);

// Your latest posts title setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[your_latest_posts_title]',
	array(
		'default'           => $options['your_latest_posts_title'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control( 'blogpost_theme_options[your_latest_posts_title]',
	array(
		'label'             => esc_html__( 'Your Latest Posts Title', 'blogpost' ),
		'description'       => esc_html__( 'This option only works if Static Front Page is set to "Your latest posts."', 'blogpost' ),
		'section'           => 'blogpost_archive_section',
		'type'				=> 'text',
		'active_callback'	=> function( $control ) {
			return !(
				blogpost_is_static_homepage_enable( $control )
			);
		}
	)
);

// features content type control and setting
$wp_customize->add_setting( 'blogpost_theme_options[blog_column]',
	array(
		'default'          	=> $options['blog_column'],
		'sanitize_callback' => 'blogpost_sanitize_select',
	)
);

$wp_customize->add_control( 'blogpost_theme_options[blog_column]',
	array(
		'label'             => esc_html__( 'Column Layout', 'blogpost' ),
		'section'           => 'blogpost_archive_section',
		'type'				=> 'select',
		'choices'			=> array( 
			'col-1'		=> esc_html__( 'One Column', 'blogpost' ),
			'col-2'		=> esc_html__( 'Two Column', 'blogpost' ),
			'col-3'		=> esc_html__( 'Three Column', 'blogpost' ),
		),
	)
);
