<?php
/**
 * Weekly Top Section options
 *
 * @package Theme Palace
 * @subpackage Blogpost
 * @since Blogpost 1.0.0
 */

// Add Weekly Top section
$wp_customize->add_section( 'blogpost_weekly_top_section',
    array(
        'title'             => esc_html__( 'Weekly Top','blogpost' ),
        'description'       => esc_html__( 'Weekly Top Section options.', 'blogpost' ),
        'panel'             => 'blogpost_front_page_panel',
    )
);

// Weekly Top content enable control and setting
$wp_customize->add_setting( 'blogpost_theme_options[weekly_top_section_enable]',
    array(
        'default'           =>  $options['weekly_top_section_enable'],
        'sanitize_callback' => 'blogpost_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Blogpost_Switch_Control( $wp_customize,
    'blogpost_theme_options[weekly_top_section_enable]',
        array(
            'label'             => esc_html__( 'Weekly Top Section Enable', 'blogpost' ),
            'section'           => 'blogpost_weekly_top_section',
            'on_off_label'      => blogpost_switch_options(),
        ) 
    )
);

// Weekly Top title setting and control
$wp_customize->add_setting( 'blogpost_theme_options[weekly_top_title]',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => $options['weekly_top_title'],
        'transport'         => 'postMessage',
    )
);

$wp_customize->add_control( 'blogpost_theme_options[weekly_top_title]',
    array(
        'label'             => esc_html__( 'Section Title', 'blogpost' ),
        'section'           => 'blogpost_weekly_top_section',
        'active_callback'   => 'blogpost_is_weekly_top_section_enable',
        'type'              => 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'blogpost_theme_options[weekly_top_title]',
        array(
            'selector'            => '#blogpost_weekly_top .section-header h2.section-title',
            'settings'            => 'blogpost_theme_options[weekly_top_title]',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'blogpost_weekly_top_title_partial',
        )
    );
}

// Weekly Top section sub title control and setting
$wp_customize->add_setting('blogpost_theme_options[weekly_top_sub_title]',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'transport' => 'postMessage',
        'default'  => $options['weekly_top_sub_title'],
    )
);

$wp_customize->add_control('blogpost_theme_options[weekly_top_sub_title]',
    array(
        'label' => esc_html__('Section Sub Title', 'blogpost'),
        'section' => 'blogpost_weekly_top_section',
        'type' => 'text',
        'active_callback' => 'blogpost_is_weekly_top_section_enable',
    )
);

$wp_customize->selective_refresh->add_partial('blogpost_theme_options[weekly_top_sub_title]',
    array(
        'selector' => '#blogpost_weekly_top p.section-subtitle',
        'render_callback' => 'blogpost_weekly_top_sub_title_partial',
    )
);

// Add dropdown category setting and control.
$wp_customize->add_setting(  'blogpost_theme_options[weekly_top_content_category]',
    array(
        'sanitize_callback' => 'blogpost_sanitize_single_category',
    )
);

$wp_customize->add_control( new Blogpost_Dropdown_Taxonomies_Control( $wp_customize,
    'blogpost_theme_options[weekly_top_content_category]',
        array(
            'label'             => esc_html__( 'Select Category', 'blogpost' ),
            'description'       => esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'blogpost' ),
            'section'           => 'blogpost_weekly_top_section',
            'type'              => 'dropdown-taxonomies',
            'active_callback'   => 'blogpost_is_weekly_top_section_enable'
        )
    )
);

// Weekly Top content type control and setting
$wp_customize->add_setting( 'blogpost_theme_options[weekly_top_column]',
    array(
        'default'          	=> $options['weekly_top_column'],
        'sanitize_callback' => 'blogpost_sanitize_select',
    )
);

$wp_customize->add_control( 'blogpost_theme_options[weekly_top_column]',
    array(
        'label'             => esc_html__( 'Column Layout', 'blogpost' ),
        'section'           => 'blogpost_weekly_top_section',
        'type'				=> 'select',
        'active_callback' 	=> 'blogpost_is_weekly_top_section_enable',
        'choices'			=> array( 
            'col-1'		=> esc_html__( 'One Column', 'blogpost' ),
            'col-2'		=> esc_html__( 'Two Column', 'blogpost' ),
            'col-3'		=> esc_html__( 'Three Column', 'blogpost' ),
            'col-4'		=> esc_html__( 'Four Column', 'blogpost' ),
        ),
    )
);