<?php
/**
 * Gallery Slider Section options
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */

// Add Gallery Slider section
$wp_customize->add_section( 'blogpost_main_section',
	array(
		'title'             => esc_html__( 'Main Section','blogpost' ),
		'description'       => esc_html__( 'Main Section options.', 'blogpost' ),
		'panel'             => 'blogpost_front_page_panel',
	)
);

// Gallery Slider content enable control and setting
$wp_customize->add_setting( 'blogpost_theme_options[main_section_enable]', 
	array(
		'default'			=> 	$options['main_section_enable'],
		'sanitize_callback' => 'blogpost_sanitize_switch_control',
	) 
);

$wp_customize->add_control( new  Blogpost_Switch_Control( $wp_customize,
	'blogpost_theme_options[main_section_enable]',
		array(
			'label'             => esc_html__( 'Main Section Enable', 'blogpost' ),
			'section'           => 'blogpost_main_section',
			'on_off_label' 		=> blogpost_switch_options(),
		)
	)
);

// Gallery Slider autoplay enable control and setting
$wp_customize->add_setting( 'blogpost_theme_options[main_autoplay_enable]',
	array(
		'default'			=> 	$options['main_autoplay_enable'],
		'sanitize_callback' => 'blogpost_sanitize_switch_control',
	)
);

$wp_customize->add_control( new  Blogpost_Switch_Control( $wp_customize,
	'blogpost_theme_options[main_autoplay_enable]',
		array(
			'label'             => esc_html__( 'Slider Autoplay Enable', 'blogpost' ),
			'section'           => 'blogpost_main_section',
			'active_callback'   => 'blogpost_is_main_section_enable',
			'on_off_label' 		=> blogpost_switch_options(),
		)
	)
);

// Weekly Top title setting and control
$wp_customize->add_setting( 'blogpost_theme_options[main_title]',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => $options['main_title'],
        'transport'         => 'postMessage',
    )
);

$wp_customize->add_control( 'blogpost_theme_options[main_title]',
    array(
        'label'             => esc_html__( 'Section Title', 'blogpost' ),
        'section'           => 'blogpost_main_section',
        'active_callback'   => 'blogpost_is_main_section_enable',
        'type'              => 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'blogpost_theme_options[main_title]',
        array(
            'selector'            => '#blogpost_main .section-header h2.section-title',
            'settings'            => 'blogpost_theme_options[main_title]',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'blogpost_main_title_partial',
        )
    );
}

// Weekly Top section sub title control and setting
$wp_customize->add_setting('blogpost_theme_options[main_sub_title]',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'transport' => 'postMessage',
        'default'  => $options['main_sub_title'],
    )
);

$wp_customize->add_control('blogpost_theme_options[main_sub_title]',
    array(
        'label' => esc_html__('Section Sub Title', 'blogpost'),
        'section' => 'blogpost_main_section',
        'type' => 'text',
        'active_callback' => 'blogpost_is_main_section_enable',
    )
);

$wp_customize->selective_refresh->add_partial('blogpost_theme_options[main_sub_title]',
    array(
        'selector' => '#blogpost_main .section-header span',
        'render_callback' => 'blogpost_main_sub_title_partial',
    )
);

for ( $i = 1; $i <= $options['main_count']; $i++ ) :

	// slider posts drop down chooser control and setting
	$wp_customize->add_setting( 'blogpost_theme_options[main_content_post_'. $i .']', 
		array(
			'sanitize_callback' => 'blogpost_sanitize_page',
		)
	);

	$wp_customize->add_control( new  Blogpost_Dropdown_Chooser( $wp_customize,
		'blogpost_theme_options[main_content_post_'. $i .']',
			array(
				'label'             => sprintf(esc_html__( 'Select Post : %d', 'blogpost'), $i ),
				'section'           => 'blogpost_main_section',
				'choices'			=> blogpost_post_choices(),
				'active_callback'	=> 'blogpost_is_main_section_enable',
			)
		)
	);

	// Blogpost_Customize_Horizontal_Line
    $wp_customize->add_setting('blogpost_theme_options[main_separator'. $i .']',
		array(
			'sanitize_callback'      => 'blogpost_sanitize_html',
		)
	);

    $wp_customize->add_control(new Blogpost_Customize_Horizontal_Line($wp_customize,
		'blogpost_theme_options[main_separator'. $i .']',
			array(
				'active_callback'       => 'blogpost_is_main_section_enable',
				'type'                  =>'hr',
				'section'               =>'blogpost_main_section',
			)
		)
	);

endfor;