<?php
/**
 * Latest Posts Section options
 *
 * @package Theme Palace
 * @subpackage Blogpost
 * @since Blogpost 1.0.0
 */

// Add Latest Posts section
$wp_customize->add_section( 'blogpost_latest_posts_section',
    array(
        'title'             => esc_html__( 'Latest Posts','blogpost' ),
        'description'       => esc_html__( 'Latest Posts Section options.', 'blogpost' ),
        'panel'             => 'blogpost_front_page_panel',
    )
);

// Latest Posts content enable control and setting
$wp_customize->add_setting( 'blogpost_theme_options[latest_posts_section_enable]',
    array(
        'default'           =>  $options['latest_posts_section_enable'],
        'sanitize_callback' => 'blogpost_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Blogpost_Switch_Control( $wp_customize,
    'blogpost_theme_options[latest_posts_section_enable]',
        array(
            'label'             => esc_html__( 'Latest Posts Section Enable', 'blogpost' ),
            'section'           => 'blogpost_latest_posts_section',
            'on_off_label'      => blogpost_switch_options(),
        )
    )
);

// blog title setting and control
$wp_customize->add_setting( 'blogpost_theme_options[latest_posts_title]',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => $options['latest_posts_title'],
        'transport'         => 'postMessage',
    )
);

$wp_customize->add_control( 'blogpost_theme_options[latest_posts_title]',
    array(
        'label'             => esc_html__( 'Section Title', 'blogpost' ),
        'section'           => 'blogpost_latest_posts_section',
        'active_callback'   => 'blogpost_is_latest_posts_section_enable',
        'type'              => 'text',
    ) 
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'blogpost_theme_options[latest_posts_title]',
        array(
            'selector'            => '#content-wrapper .section-header h2.section-title',
            'settings'            => 'blogpost_theme_options[latest_posts_title]',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'blogpost_latest_posts_title_partial',
        )
    );
}

// Add dropdown categories setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[latest_posts_category_exclude]',
    array(
        'sanitize_callback' => 'blogpost_sanitize_category_list',
    )
);

$wp_customize->add_control( new Blogpost_Dropdown_Multiple_Chooser( $wp_customize,
    'blogpost_theme_options[latest_posts_category_exclude]',
        array(
            'label'             => esc_html__( 'Select Excluding Categories', 'blogpost' ),
            'section'           => 'blogpost_latest_posts_section',
            'type'              => 'dropdown_multiple_chooser',
            'choices'           =>  blogpost_category_choices(),
            'active_callback'   => 'blogpost_is_latest_posts_section_enable'
        )
    )
);

// latest posts Excerpt length setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[latest_posts_excerpt_length]',
	array(
		'sanitize_callback' => 'blogpost_sanitize_number_range',
		'default'			=> $options['latest_posts_excerpt_length'],
	)
);

$wp_customize->add_control( 'blogpost_theme_options[latest_posts_excerpt_length]',
	array(
		'label'       		=> esc_html__( 'Excerpt Length', 'blogpost' ),
		'description' 		=> esc_html__( 'Total words to be displayed in latest posts section', 'blogpost' ),
		'section'     		=> 'blogpost_latest_posts_section',
		'type'        		=> 'number',
		'active_callback' 	=> 'blogpost_is_latest_posts_section_enable',
	)
);