<?php
/**
 * Call To Action Section options
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */

// Add Call To Action section
$wp_customize->add_section( 'blogpost_call_to_action_section',
    array(
        'title'             => esc_html__( 'Call To Action','blogpost' ),
        'description'       => esc_html__( 'Call To Action Section options.', 'blogpost' ),
        'panel'             => 'blogpost_front_page_panel',
    )
);

// Call To Action content enable control and setting
$wp_customize->add_setting( 'blogpost_theme_options[call_to_action_section_enable]',
    array(
        'default'			=> 	$options['call_to_action_section_enable'],
        'sanitize_callback' => 'blogpost_sanitize_switch_control',
    )
);

$wp_customize->add_control( new  Blogpost_Switch_Control( $wp_customize,
    'blogpost_theme_options[call_to_action_section_enable]',
        array(
            'label'             => esc_html__( 'Call To Action Section Enable', 'blogpost' ),
            'section'           => 'blogpost_call_to_action_section',
            'on_off_label' 		=> blogpost_switch_options(),
        )
    )
);

// call_to_action section sub title control and setting
$wp_customize->add_setting('blogpost_theme_options[call_to_action_section_title]',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'transport' => 'postMessage',
        'default'  => $options['call_to_action_section_title'],
    )
);

$wp_customize->add_control('blogpost_theme_options[call_to_action_section_title]',
    array(
        'label' => esc_html__('Section Sub Title', 'blogpost'),
        'section' => 'blogpost_call_to_action_section',
        'type' => 'text',
        'active_callback' => 'blogpost_is_call_to_action_section_enable',
    )
);

$wp_customize->selective_refresh->add_partial('blogpost_theme_options[call_to_action_section_title]',
    array(
        'selector' => '#blogpost_call_to_action h2.section-title',
        'render_callback' => 'blogpost_call_to_action_section_title_partial',
    )
);

$wp_customize->add_setting( 'blogpost_theme_options[call_to_action_content_page]',
    array(
        'sanitize_callback' => 'blogpost_sanitize_page',
    )
);

$wp_customize->add_control( new  Blogpost_Dropdown_Chooser( $wp_customize,
    'blogpost_theme_options[call_to_action_content_page]',
        array(
            'label'             => esc_html__( 'Select Page', 'blogpost' ),
            'section'           => 'blogpost_call_to_action_section',
            'choices'			=> blogpost_page_choices(),
            'active_callback'	=> 'blogpost_is_call_to_action_section_enable',
        )
    )
);

// Call To Action read more setting and control
$wp_customize->add_setting( 'blogpost_theme_options[call_to_action_read_more]',
    array(
        'default'			=> $options['call_to_action_read_more'],
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         =>'postMessage',
    )
);

$wp_customize->add_control( 'blogpost_theme_options[call_to_action_read_more]',
    array(
        'label'           	=> esc_html__( 'Read More Text', 'blogpost' ),
        'section'        	=> 'blogpost_call_to_action_section',
        'active_callback' 	=> 'blogpost_is_call_to_action_section_enable',
        'type'				=> 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'blogpost_theme_options[call_to_action_read_more]',
        array(
            'selector'            => '#blogpost_call_to_action div.view-more a',
            'settings'            => 'blogpost_theme_options[call_to_action_read_more]',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'blogpost_call_to_action_read_more_partial',
        )
    );
}

// Call To Action Excerpt length setting and control.
$wp_customize->add_setting( 'blogpost_theme_options[call_to_action_excerpt_length]',
	array(
		'sanitize_callback' => 'blogpost_sanitize_number_range',
		'default'			=> $options['call_to_action_excerpt_length'],
	)
);

$wp_customize->add_control( 'blogpost_theme_options[call_to_action_excerpt_length]',
	array(
		'label'       		=> esc_html__( 'Excerpt Length', 'blogpost' ),
		'description' 		=> esc_html__( 'Total words to be displayed in Call To Action section', 'blogpost' ),
		'section'     		=> 'blogpost_call_to_action_section',
		'type'        		=> 'number',
        'active_callback'	=> 'blogpost_is_call_to_action_section_enable'
	)
);
