<?php
/**
 * Customizer default options
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 * @return array An array of default values
 */

function blogpost_get_default_theme_options() {
	$theme_data = wp_get_theme();
	$blogpost_default_options = array(
		// Color Options
		'header_title_color'			    => '#000',
		'header_tagline_color'			    => '#000',
		'header_txt_logo_extra'			    => 'show-all',
		'home_layout'						=> 'default-design',

		// breadcrumb
		'breadcrumb_enable'				    => (bool) true,
		'breadcrumb_separator'			    => '/',
				
		// homepage options
		'enable_frontpage_content' 			=> false,

		// layout 
		'site_layout'         			    => 'wide',
		'sidebar_position'         		    => 'right-sidebar',
		'post_sidebar_position' 		    => 'right-sidebar',
		'page_sidebar_position' 		    => 'right-sidebar',
		'menu_sticky'					    => (bool) false,
		'search_icon_in_primary_menu_enable'=> (bool) true,

		// excerpt options
		'long_excerpt_length'               => 25,

		// pagination options
		'pagination_enable'         	    => (bool) true,
		'pagination_type'         		    => 'default',

		// footer options
		'copyright_text'           		    => sprintf( esc_html_x( 'Copyright &copy; %1$s %2$s. ', '1: Year, 2: Site Title with home URL', 'blogpost' ), '[the-year]', '[site-link]' ),
		'scroll_top_visible'        	    => (bool) true,

		// reset options
		'reset_options'      			    => (bool) false,
		
		// homepage sections sortable

		'default_sortable' 			    	=> 'main,call_to_action,latest_posts,weekly_top',

		// blog/archive options
		'your_latest_posts_title' 		    => esc_html__( 'Blogs', 'blogpost' ),
		'blog_column'						=> 'col-1',

		// single post theme options
		'single_post_hide_date' 		    => (bool) false,
		'single_post_hide_author'		    => (bool) false,

		/* Front Page */

		// top bar
		'topbar_section_enable'			=> (bool) true,
		'social_menu_enable'			=> (bool) true,
		

		// hero slider
		'main_section_enable'			=> (bool) false,
		'main_sub_title'             	=> esc_html__('Design, Travel & Fashion','blogpost'),
		'main_title'    			    => esc_html__('Blog Theme About','blogpost'),
		'main_autoplay_enable'			=> (bool) true,
		'main_count'					=> 4,
		
		//weekly_top
		'weekly_top_section_enable'		   => (bool) false,
		'weekly_top_sub_title'             => esc_html__('Put your awesome subtitle here to showcase','blogpost'),
		'weekly_top_title'    			   => esc_html__('Browse More Posts','blogpost'),
		'weekly_top_count'				   => 4,
		'weekly_top_column'				   => 'col-4',
		
		//latest_posts 
		'latest_posts_section_enable'		   	=> (bool) false,
		'latest_posts_count'				   	=> 4,
		'latest_posts_excerpt_length'		   	=> 30,
		'latest_posts_column'				   	=> 'col-3',
		'latest_posts_title'				   	=> esc_html__( 'This is where we tell stories...', 'blogpost' ),

		//call_to_action
		'call_to_action_section_enable' 		=> false,
		'call_to_action_read_more'				=>	esc_html__('Read More', 'blogpost'),
		'call_to_action_section_title'			=>	esc_html__('Visual Branding Design & Logo Branding Inspiration', 'blogpost'),
		'call_to_action_excerpt_length'			=>	25,

	);

	$output = apply_filters( 'blogpost_default_theme_options', $blogpost_default_options );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}