<?php
/**
 * Customizer active callbacks
 *
 * @package Theme Palace
 * @subpackage  Blogpost
 * @since  Blogpost 1.0.0
 */


if ( ! function_exists( 'blogpost_is_static_homepage_enable' ) ) :
	/**
	 * Check if static homepage is enabled.
	 *
	 * @since Blogpost 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function blogpost_is_static_homepage_enable( $control ) {
		return ( 'page' == $control->manager->get_setting( 'show_on_front' )->value() );
	}
endif;

if ( ! function_exists( 'blogpost_is_breadcrumb_enable' ) ) :
	/**
	 * Check if breadcrumb is enabled.
	 *
	 * @since  Blogpost 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function blogpost_is_breadcrumb_enable( $control ) {
		return $control->manager->get_setting( 'blogpost_theme_options[breadcrumb_enable]' )->value();
	}
endif;

if ( ! function_exists( 'blogpost_is_pagination_enable' ) ) :
	/**
	 * Check if pagination is enabled.
	 *
	 * @since  Blogpost 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function blogpost_is_pagination_enable( $control ) {
		return $control->manager->get_setting( 'blogpost_theme_options[pagination_enable]' )->value();
	}
endif;


/**
 * Check if Main section is enabled.
 *
 * @since  Blogpost 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function blogpost_is_main_section_enable( $control ) {
	return ( $control->manager->get_setting( 'blogpost_theme_options[main_section_enable]' )->value() );
}

/**
 * Check if Call To Action section is enabled.
 *
 * @since  Blogpost 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function blogpost_is_call_to_action_section_enable( $control ) {
	return ( $control->manager->get_setting( 'blogpost_theme_options[call_to_action_section_enable]' )->value() );
}

/**
 * Check if latest_posts section is enabled.
 *
 * @since  Blogpost 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function blogpost_is_latest_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'blogpost_theme_options[latest_posts_section_enable]' )->value() );
}

/**
 * Check if weekly_top section is enabled.
 *
 * @since  Blogpost 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function blogpost_is_weekly_top_section_enable( $control ) {
	return ( $control->manager->get_setting( 'blogpost_theme_options[weekly_top_section_enable]' )->value() );
}
