<?php
	/**
	 * The header for our theme.
	 *
	 * This is the template that displays all of the <head> section and everything up until <div id="content">
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
	 *
	 * @package Theme Palace
	 * @subpackage  Blogpost
	 * @since  Blogpost 1.0.0
	 */

	/**
	 * blogpost_doctype hook
	 *
	 * @hooked blogpost_doctype -  10
	 *
	 */
	do_action( 'blogpost_doctype' );

?>
<head>
<?php
	/**
	 * blogpost_before_wp_head hook
	 *
	 * @hooked blogpost_head -  10
	 *
	 */
	do_action( 'blogpost_before_wp_head' );

	wp_head(); 
?>
</head>

<body <?php body_class(); ?>>

<?php do_action( 'wp_body_open' ); ?>
<?php
	/**
	 * blogpost_page_start_action hook
	 *
	 * @hooked blogpost_page_start -  10
	 *
	 */
	do_action( 'blogpost_page_start_action' ); 

	/**
	 * blogpost_loader_action hook
	 *
	 * @hooked blogpost_loader -  10
	 *
	 */
	do_action( 'blogpost_before_header' );

	/**
	 * blogpost_header_action hook
	 *
	 * @hooked blogpost_site_branding -  10
	 * @hooked blogpost_header_start -  20
	 * @hooked blogpost_site_navigation -  30
	 * @hooked blogpost_header_end -  50
	 *
	 */
	do_action( 'blogpost_header_action' );

	/**
	 * blogpost_content_start_action hook
	 *
	 * @hooked blogpost_content_start -  10
	 *
	 */
	do_action( 'blogpost_content_start_action' );

    /**
     * blogpost_header_image_action hook
     *
     * @hooked blogpost_header_image -  10
     *
     */
    do_action( 'blogpost_header_image_action' );
	
